class Array

	#
	#	すべての組み合わせを得るメソッド
	#
	#		p [['A'], ['B', 'C'], ['D', 'E', 'F'], ['G', 'H', 'I', 'J']].combi
	#
	def combi(result = Array.new, temp = Array.new)
		if(self.size != 0)
			(remain = self.dup).shift.each {|c|
				remain.combi(result, temp + [c])
			}
		else
			result.push(temp)
		end
		return result
	end
end

class Guiter_chord

	@@KEYS = Array['C', 'C#', 'D', 'D#', 'E', 'F', 'F#', 'G', 'G#', 'A', 'A#', 'B']

#	Major-chord						:C				根音＋長3度＋短3度			(完全5度)
#	Minor-chord						:Cm				根音＋短3度＋長3度			(完全5度)
#	Dominant-7th-chord				:C7				根音＋長3度＋短3度＋短3度	(短7度)
#	Major-7th-chord					:Cmaj7			根音＋長3度＋短3度＋長3度	(長7度)
#	Minor-7th-chord					:Cm7			根音＋短3度＋長3度＋短3度	(短7度)
#	Minor-Major-7th-chord			:Cmmaj7			根音＋短3度＋長3度＋長3度	(長7度)

#	Major-6th-chord					:C6				根音＋長3度＋短3度＋長2度	(長6度)
#	Minor-6th-chord					:Cm6			根音＋短3度＋長3度＋長2度	(長6度)
#	Aug.-7th-chord					:Caug7	C7+5	根音＋長3度＋長3度＋短3度	(短7度？)

#	Suspended-4th-chord				:Csus4			根音＋完全4度＋長2度
#	7th-Suspended-4th-chord			:C7sus4			根音＋完全4度＋長2度+＋短3度

	@@RULES = Hash[
		'',			[0, 4, 3],
		'm',		[0, 3, 4],
		'7',		[0, 4, 3, 3],
		'M7',		[0, 4, 3, 4],
		'm7',		[0, 3, 4, 3],
		'6',		[0, 4, 3, 2],
		'm6',		[0, 3, 4, 2],
		'sus4',		[0, 5, 2],
		'7sus4',	[0, 5, 2, 3],
	]

	@@OCTAVES = Array.new
	(0..6).each {|o|											# 6 octave
#	(2..8).each {|o|											# 6 octave
		@@KEYS.each {|k|
			@@OCTAVES.push("#{o}#{k}")
		}
	}

	@@FLETS = Array.new; h = 5
	@@FLETS.push(@@OCTAVES[28, h])	# string 1 open and 1-4 flet
	@@FLETS.push(@@OCTAVES[23, h])
	@@FLETS.push(@@OCTAVES[19, h])	# or 4?
	@@FLETS.push(@@OCTAVES[14, h])
	@@FLETS.push(@@OCTAVES[ 9, h])
	@@FLETS.push(@@OCTAVES[ 4, h])	# string 6

	#-----------------------------------------------------------
	#
	#	コンストラクタ
	#
	def initialize(chord)
		@chord = chord
		@chord =~ /^([A-G]#?)(.*)/
		@base = $1; @type = $2
#		p @chord
		return @chord

# TODO
#  手動設定されたコードには手を出さないようにする

	end

	#-----------------------------------------------------------
	#
	#	コードの構成音を得る
	#
	def resolve
		@elements = Array.new
		p = @@KEYS.index(@base)
		@@RULES[@type].each {|d|
			@elements.push(@@KEYS[(p += d) % 12])
		}
#		p @elements
		return @elements
	end

	#-----------------------------------------------------------
	#
	#	弦の割り当てを得る
	#
	#		ベース弦の解決は行う
	#		同じ弦を2箇所で押さえることがある
	#		現状、異なるベース弦(XonY)の指定は不可
	#
	def string_resolve
		self.resolve unless(@elements)

		@holds = Array.new
		(0..5).each {|ss| s = 5 - ss							# extract flet position for holds
			@@FLETS[s].each_index {|f|
				@holds.push([s, f, @@FLETS[s][f]]) if(@elements.index(@@FLETS[s][f][1, 9]))
			}
		}

		bstr = nil; @holds.delete_if {|h|						# resolve base string
			bstr ? h[0] == bstr : (h[2][1, 9] != @base ? true : (bstr = h[0] and false))
		}
#		p @holds
		return @holds
	end

	#-----------------------------------------------------------
	#
	#	すべての押さえ方を調べる
	#
	def all_patterns
		self.string_resolve unless(@holds)

		string_has = Array.new
		s = nil; temp = Array.new								# 弦ごとに配列をまとめる
		@holds.each {|h|
			if(h[0] != s)
				string_has.push(temp) if(temp.size > 0)
				s = h[0]; temp = Array.new
			end
			temp.push(h)
		}
		string_has.push(temp) if(temp.size > 0)

		@patterns = string_has.combi							# すべての押さえ方を調べる

		@patterns.delete_if {|c|
			k = Hash.new; c.each {|f|							# すべてのキーが含まれているか？
				k[f[2][1, 9]] = true								# アルペジオの時も考慮するとよいか？
			}
			k.size != @elements.size
		}
#		p @patterns
		return @patterns
	end

	#-----------------------------------------------------------
	#
	#	押さえやすい(だろう)順に並べて返す
	#
	def sort_patterns
		self.all_patterns unless(@patterns)

		@patterns.each {|c|										# 押さえやすさを得点化する
			point = 100
			f = Hash.new; c.each {|k|
				point += 10 if(k[1] == 0)						# 開放弦は得点
				point -= 10 if(k[1] != 0)						# 押さえる数は減点
				f[k[1]] = true
			}
			point -= f.size * 20								# 押さえる場所は減点
			c.unshift(point)
		}

		@patterns.sort {|a, b| a[0] <=> b[0] }					# 得点順に並べ替える

		@patterns.each {|c| c.shift }							# 得点情報を削除

#		p @patterns
		return @patterns
	end

	#-----------------------------------------------------------
	#
	#	キーを返す
	#
	def keys(holds)
		k = Array.new
		holds.each {|h|
			k.push(h[2])
		}
		return k
	end

	#-----------------------------------------------------------
	#
	#	ダイアグラムを返す
	#
	def diagram(holds)
		dgm = ''
		(0..5).each {|s|
			p = Array['x', '-', '-', '-', '-', '-', '-']
			holds.each {|h|
				p[h[1]] = 'o' and p[0] == 'x' and p[0] = ' ' if(h[0] == s)
#				p[h[1]] = "#{h[2]}" and p[0] == 'x' and p[0] = ' ' if(h[0] == s)
			}
			dgm += sprintf("%d: %2s |------%s-+------%s-+------%s-+------%s-+------%s-+------%s-+---\n", s + 1, *p)
#			dgm += sprintf("%d: %4s | %6s + %6s + %6s + %6s + %6s + %6s +\n", s + 1, *p)
		}
		return dgm
	end
end

