// gcc -o playmidi playmidi.c -l winmm

#include <stdio.h>
#include <unistd.h>
#include <windows.h>
#include <mmsystem.h>

int main(int argc, char *argv[]) {
	char cmd[1024];
	int playtime;

	sprintf(cmd, "open %s alias contents", argv[1]);
	if(mciSendString(cmd, NULL, 0, 0))
		return -1;

	mciSendString("set contents time format milliseconds", NULL, 0, 0);
	if(mciSendString("status contents length", cmd, 1024, 0))
		return -1;

	if((playtime = atoi(cmd) / 1000) <= 0)
		return -1;

	if(mciSendString("play contents", NULL, 0, 0))
		return -1;

	sleep(playtime + 1);

	mciSendString("stop contents", NULL, 0, 0);

	return 0;
}

