;###############################################################################
;
;	PIC USB PLOTTER I/F
;
;		Assemble by pa-3.0.5s(b5e0048474cce2a1ba49a54faf9b1e86 */usr/local/bin/pa.exe)
;
;-------------------------------------------------------------------------------
;
;	إå
;
		include		my16f648.h
		.16f84				; PIC16F84()

;-------------------------------------------------------------------------------
;
;	ϥݡ
;
;			SB x3210
MYTRISA		equ	01100000b		; (0:, 1:())
STB		equ	7
BUSY		equ	 6

;			7654gTRn
MYTRISB		equ	00001010b		; (0:, 1:())
TX		equ	     2
RX		equ	      1
LED		equ	       0

;-------------------------------------------------------------------------------
;
;	EEPROM
;
		eeorg	0			; EEDATA

;-------------------------------------------------------------------------------
;
;	ꥻ
;
		org	20h			; ޥå

aTemp		ds	1			; A쥸
sTemp		ds	1			; STATUS쥸

bufA		ds	1			; PORTAѥ
bufB		ds	1			; PORTBѥ

waitCntS	ds	1			; Ԥѥ
waitCntM	ds	1
waitCntL	ds	1

;-------------------------------------------------------------------------------
;
;	ץॻ
;
		org	00h			; ꥻåȥ٥
		JP	start

;-------------------------------------------------------------------------------
;
;	߽
;
		org	04h			; ߥ٥
isrStart
;		LD	(aTemp),A		; 쥸
;		SWAP	(STATUS)>A
;		RES	RP0, (STATUS)		; Х0
;		LD	(sTemp),A
;isrTimer
;		BIT	T0IF, (INTCON)		; ޳ȯ=1
;		JP	Z, isrEnd
;		RES	T0IF, (INTCON)		; ȯե饰ߤ
;		INC	(pSec)			; вÿ + 1
;isrEnd
;		SWAP	(sTemp)>A		; 쥸
;		LD	(STATUS),A
;		SWAP	(aTemp)
;		SWAP	(aTemp)>A
		RETI

;-------------------------------------------------------------------------------
;
;	å׽
;
start
		RES	RP1, (STATUS)
		RES	RP0, (STATUS)		; Х0

		CLR	(PORTA)			; ݡAꥢ
		CLR	(PORTB)			; ݡBꥢ

		LD	A, 00000111b
		LD	(CMCON), A		; ѥ졼OFF

		SET	RP0, (STATUS)		; Х1

		LD	A, MYTRISA
		LD	(TRISA), A		; ݡA
		LD	A, MYTRISB
		LD	(TRISB), A		; ݡB

		RES	RP0, (STATUS)		; Х0
timerSet
		CLR	(WDT)			; åɥåޡץꥹ饯ꥢ
		CLR	(TMR0)			; ޥꥢ

		SET	RP0, (STATUS)		; Х1

		LD	A, 11111111b		; :11111111b
		LD	(OPTION), A		; 7:GPIOץ륢å(0:Ѥ)
						; 6:GP2ߥݡѲ(0:Ω)
						; 5:TMR0åӥå(0:)
						; 4:GP2ѲTMR0ûߥ(0:Ω)
						; 3:ץꥹƥӥå(0:TMR0)
						; 2~0ץꥹ졼ӥå(111:1/128)

		RES	RP0, (STATUS)		; Х0
intStart
		LD	A, 00000000b		; :00000000b
		LD	(INTCON), A		; 7:Хߥ֥͡
						; 5:TMR0Сեߥ֥͡
						; 4:GP2ݡѲߥ֥͡
						; 3:ݡѲߥ֥͡

;--------------------------------------------------------------------------------
;
;	20üLEDǽ(å®ٷ¬)
;
;getClock
;		SET	LED, (PORTB)
;
;		LD	A, 100			; 100ꤹȡ
;		CALL	WAITnx01sm25us		; 2Ԥ 100 x 100ms - 25us 񤹤
;		LD	A, 6			; 10ꤹȡ
;		CALL	WAITnx3p5us		; 2Ԥ 6 x 3 + 5 = 23us 
;
;		RES	LED, (PORTB)
;
;		LD	A, 100			; 100ꤹȡ
;		CALL	WAITnx01sm25us		; 2Ԥ 100 x 100ms - 25us 񤹤
;		LD	A, 6			; 10ꤹȡ
;		CALL	WAITnx3p5us		; 2Ԥ 6 x 3 + 5 = 23us 
;
;		JP	getClock

;--------------------------------------------------------------------------------
;
;	ꥢ
;

		SET	RP0, (STATUS)		; Х1

		LD	A, 25			; 9600bps on 4MHz
		LD	(SPBRG), A		; Baud Rate Generator
		SET	BRGH, (TXSTA)		; High Baud Rate Select(High/Low)
		RES	SYNC, (TXSTA)		; USART Mode Select(Synchronous/Asynchronous)

		RES	RP0, (STATUS)		; Х0

		SET	SPEN, (RCSTA)		; Serial Port Enable

		SET	CREN, (RCSTA)		; Continuous Receive Enable

		SET	RP0, (STATUS)		; Х1
		SET	TXEN, (TXSTA)		; Transmit Enable
		RES	RP0, (STATUS)		; Х0

;--------------------------------------------------------------------------------
;
;	ᥤ
;
main
		CALL	recv			; ꥢ
		CALL	psend			; ѥ
		CALL	send			; ꥢ
		JP	main

;--------------------------------------------------------------------------------
;
;	ꥢ
;		ǡޤǥ֥å
;		ǡA쥸֤
;
recv
		CLR	(WDT)			; åɥåޡץꥹ饯ꥢ
		BIT	RCIF, (PIR1)		; ե饰å
		JP	Z, recv
		BIT	OERR, (RCSTA)		; Х󥨥顼å
		JP	NZ, ovRunErr
		BIT	FERR, (RCSTA)		; ե졼ߥ󥰥顼å
		JP	NZ, frameErr
		LD	A, (RCREG)		; 顼ʤǡ
		RET
ovRunErr
		RES	CREN, (RCSTA)
		SET	CREN, (RCSTA)		; ϩꥻå(OERRꥢ)
		LD	A, 0E1h			; ''
		BIT	FERR, (RCSTA)		; ե졼ߥ󥰥顼å
		RET	Z
frameErr
		LD	A, (RCREG)		; ߤۤ
		LD	A, 87h			; ''
		RET

;--------------------------------------------------------------------------------
;
;	ꥢ
;		A쥸Υǡ
;
send
		LD	A, 41h
		LD	(TXREG), A		; USART Transmit data register
		RET

;--------------------------------------------------------------------------------
;
;	ѥ
;		A쥸Υǡ
;
psend
		SET	LED, (PORTB)		; LED
psend1
		BIT	BUSY, (PORTA)		; BUSYǧ
		JP	NZ, psend1

		LD	(bufA), A		; ǡå
		LD	(bufB), A

		LD	A, 11110000B
		AND	(PORTA), A
		AND	(bufB), A

		LD	A, 00001111B
		AND	(PORTB), A
		AND	(bufA), A

		LD	A, (bufA)
		OR	(PORTA), A
		LD	A, (bufB)
		OR	(PORTB), A

		SET	STB, (PORTA)		; STBȥꥬ
psend2
		BIT	BUSY, (PORTA)		; BUSYǧ
		JP	Z, psend2

		RES	STB, (PORTA)		; STB᤹

		RES	LED, (PORTB)		; LED

		RET

################################################################################
#
#	Ԥ()
#
#		LD	A, 10			; 10ꤹȡ
#		CALL	WAITnx3p5us		; 2Ԥ 10 x 3 + 5 = 35us 
#
WAITnx3p5us
		LD	(waitCntS), A
WAITnx3p5us1
		DJNZ	(waitCntS), WAITnx3p5us1
		RET

################################################################################
#
#	Ԥ()
#
#		LD	A, 200			; 0.1äξ硢200ꤹȡ
#		CALL	WAITnx500m35us		; 2Ԥ 200 x 500 - 35 = 99.965ms 񤹤
#
WAITnx500m35us
		LD	(waitCntM), A
		JP	WAITnx500m35us2
WAITnx500m35us1	NOP
		LD	A, 12			;  12 x 3 + 5 =  41us
		CALL	WAITnx3p5us		;		λԤ
WAITnx500m35us2	LD	A, 150			; 150 x 3 + 5 = 455us
		CALL	WAITnx3p5us		;		λԤ
		DJNZ	(waitCntM), WAITnx500m35us1
		RET

################################################################################
#
#	Ԥ()
#
#		LD	A, 10			; 1äξ硢10ꤹȡ
#		CALL	WAITnx01sm25us		; 2Ԥ 10 x 100ms - 25us 񤹤
#
WAITnx01sm25us
		LD	(waitCntL), A
		JP	WAITnx01sm25us2
WAITnx01sm25us1	LD	A, 9
		CALL	WAITnx3p5us
WAITnx01sm25us2	LD	A, 200
		CALL	WAITnx500m35us
		DJNZ	(waitCntL), WAITnx01sm25us1
		RET

